#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>

GtkWidget *entry_from,*entry_to;
GtkWidget *chk;
GtkWidget *sb1,*sb2;


static void convert_ok (GtkWidget *wid, GtkWidget *win)
{
  GtkWidget *dialog = NULL;

  dialog = gtk_message_dialog_new (GTK_WINDOW (win), GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, "Convert completed!");
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

static void dt_convert (GtkWidget *wid, GtkWidget *win)
{
  char command[1024]={"\0"};
  if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(chk))){
    sprintf(command,"./dt2txt %s %s %d %d",gtk_entry_get_text (GTK_ENTRY(entry_from)), gtk_entry_get_text (GTK_ENTRY(entry_to)),(int)gtk_spin_button_get_value (GTK_SPIN_BUTTON(sb1)),(int)gtk_spin_button_get_value (GTK_SPIN_BUTTON(sb2)));
  }
  else{
    sprintf(command,"./dt2txt %s %s",gtk_entry_get_text (GTK_ENTRY(entry_from)), gtk_entry_get_text (GTK_ENTRY(entry_to)));
  }
  system(command);
  convert_ok(wid,win);
}

static void dt_open (GtkWidget *wid, GtkWidget *win)
{
    GtkWidget *dialog;
    GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_OPEN;
    gint res;

    dialog = gtk_file_chooser_dialog_new ("Open File",GTK_WINDOW(win),action,"_Cancel",GTK_RESPONSE_CANCEL,"_Open",GTK_RESPONSE_ACCEPT,NULL);
    res = gtk_dialog_run (GTK_DIALOG (dialog));
    if (res == GTK_RESPONSE_ACCEPT){
        char *filename;
        GtkFileChooser *chooser = GTK_FILE_CHOOSER (dialog);
        filename = gtk_file_chooser_get_filename (chooser);
        gtk_entry_set_text (GTK_ENTRY(entry_from),filename);
        g_free (filename);
      }
    gtk_widget_destroy (dialog);
}

static void dt_save (GtkWidget *wid, GtkWidget *win)
{
    GtkWidget *dialog;
    GtkFileChooser *chooser;
    GtkFileChooserAction action = GTK_FILE_CHOOSER_ACTION_SAVE;
    gint res;

    dialog = gtk_file_chooser_dialog_new ("Save File",GTK_WINDOW(win), action,"_Cancel", GTK_RESPONSE_CANCEL,"_Save",GTK_RESPONSE_ACCEPT, NULL);
    chooser = GTK_FILE_CHOOSER (dialog);
    gtk_file_chooser_set_do_overwrite_confirmation (chooser, TRUE);
    gtk_file_chooser_set_current_name (chooser,"Untitled.txt");
    res = gtk_dialog_run (GTK_DIALOG (dialog));
    if (res == GTK_RESPONSE_ACCEPT){
        char *filename;
        filename = gtk_file_chooser_get_filename (chooser);
        gtk_entry_set_text (GTK_ENTRY(entry_to),filename);
        g_free (filename);
      }
    gtk_widget_destroy (dialog);
}

int main (int argc, char *argv[])
{
  GtkWidget *button = NULL;
  GtkWidget *win = NULL;
  GtkWidget *label;
  GtkWidget *table;

  gtk_init (&argc, &argv);

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width (GTK_CONTAINER (win), 8);
  gtk_window_set_title (GTK_WINDOW (win), "dt2txt - CASSTK SA");
  gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_CENTER);

  g_signal_connect (win, "destroy", gtk_main_quit, NULL);

  table = gtk_table_new(5, 6, TRUE);
  gtk_table_set_row_spacings(GTK_TABLE(table), 2);
  gtk_table_set_col_spacings(GTK_TABLE(table), 2);

  gtk_container_add (GTK_CONTAINER (win), table);

  label = gtk_label_new("From: ");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 0, 1);
  label = gtk_label_new("To: ");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0,1, 1, 2);

  entry_from = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry_from, 1,5, 0, 1);
  gtk_entry_set_text (GTK_ENTRY(entry_from),"../data/rt.data");

  entry_to = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry_to, 1,5, 1, 2);
  gtk_entry_set_text (GTK_ENTRY(entry_to),"../data/rt.txt");

  button = gtk_button_new_with_label ("..");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (dt_open), (gpointer) win);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 5,6, 0, 1);

  button = gtk_button_new_with_label ("..");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (dt_save), (gpointer) win);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 5,6, 1, 2);

  chk = gtk_check_button_new_with_label("Lines");
  gtk_table_attach_defaults(GTK_TABLE(table), chk, 0,1, 2, 3);

  sb1 = gtk_spin_button_new_with_range(0,100000,1);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(sb1),0);
  sb2 = gtk_spin_button_new_with_range(0,100000,1);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(sb2),100);
  gtk_table_attach_defaults(GTK_TABLE(table), sb1, 2,3, 2, 3);
  gtk_table_attach_defaults(GTK_TABLE(table), sb2, 4,5, 2, 3);
  label = gtk_label_new("Start:");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 1,2, 2, 3);
  label = gtk_label_new("End:");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 3,4, 2, 3);

  button = gtk_button_new_with_label ("Convert");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (dt_convert), (gpointer) win);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 4,5, 4, 5);

  button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  g_signal_connect (button, "clicked", gtk_main_quit, NULL);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 5,6, 4, 5);

  gtk_widget_show_all (win);
  gtk_main ();
  return 0;
}
